/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.dialog;

import filenet.vw.api.VWFieldDefinition;
import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWModeType;
import filenet.vw.api.VWParameterDefinition;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.dialog.VWSelectStepPanel;
import filenet.vw.toolkit.design.property.dialog.VWStepItem;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.tables.VWStepsListCellRenderer;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeSource;
import filenet.vw.toolkit.utils.mapui.VWMapCache;
import filenet.vw.toolkit.utils.table.VWLabelListCellRenderer;
import filenet.vw.toolkit.utils.table.VWQubbleSort;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class VWFieldUsageDialog
extends VWModalDialog
implements ActionListener,
IVWPropertyChangeSource {
    private VWToolbarBorder m_fieldBorder = null;
    private JComboBox m_fieldComboBox = null;
    private VWToolbarBorder m_submapBorder = null;
    private JComboBox m_submapComboBox = null;
    private VWToolbarBorder m_stepsBorder = null;
    private VWSelectStepPanel m_addRemovePanel = null;
    private VWToolbarBorder m_modeBorder = null;
    private JComboBox m_modeComboBox = null;
    private JButton m_closeButton = null;
    private JButton m_helpButton = null;
    private GridBagConstraints m_gbCons = null;
    protected VWFieldDefinition m_fieldDef = null;
    protected VWStepDefinition[] m_availableStepDefs = null;
    protected VWStepDefinition[] m_selectedStepDefs = null;
    private VWAuthPropertyData m_authPropertyData = null;
    private boolean m_bInit = false;
    private Vector<VWStepItem> m_stepVector = null;

    public VWFieldUsageDialog(Frame parent) {
        super(parent);
    }

    public void init(VWAuthPropertyData authPropertyData, VWFieldDefinition fieldDef) {
        try {
            this.m_authPropertyData = authPropertyData;
            this.m_fieldDef = fieldDef;
            Dimension dim = VWStringUtils.stringToDimension("665,445");
            if (dim != null) {
                this.setSize(dim);
            } else {
                this.setSize(new Dimension(600, 400));
            }
            this.setTitle(VWResource.s_fieldUsage);
            if (!this.m_bInit) {
                this.createControls();
                this.m_bInit = true;
            }
            this.initFieldComboBox();
            this.initMapComboBox();
            this.reinitialize();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void updateAvailableStepProperties(VWStepItem step) {
        try {
            this.m_modeComboBox.setEnabled(false);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void updateSelectedStepProperties(VWStepItem step) {
        try {
            VWMapNode mapNode;
            if (step != null && (mapNode = step.getDef()) != null && mapNode instanceof VWStepDefinition) {
                VWParameterDefinition paramDef = this.getParamDef((VWStepDefinition)mapNode);
                this.m_modeComboBox.removeActionListener(this);
                int mode = paramDef.getMode();
                if (mode == 1) {
                    this.m_modeComboBox.setSelectedIndex(0);
                } else if (mode == 2) {
                    this.m_modeComboBox.setSelectedIndex(1);
                } else if (mode == 3) {
                    this.m_modeComboBox.setSelectedIndex(2);
                }
                this.m_modeComboBox.addActionListener(this);
            }
            this.m_modeComboBox.setEnabled(true);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void addParamToStep(Object[] items) {
        try {
            VWFieldDefinition fieldDef = this.getSelectedFieldDefinition();
            this.m_stepVector = new Vector();
            for (int i = 0; i < items.length; ++i) {
                VWStepItem item = (VWStepItem)items[i];
                VWMapNode mapNode = item.getDef();
                if (mapNode == null || !(mapNode instanceof VWStepDefinition)) continue;
                VWParameterDefinition paramDef = ((VWStepDefinition)mapNode).createParameter(fieldDef.getName(), 3, fieldDef.getName(), fieldDef.getFieldType(), fieldDef.isArray());
                paramDef.setDescription(fieldDef.getDescription());
                item.setSelected(true);
                this.m_stepVector.addElement(item);
            }
            this.m_authPropertyData.setDirty();
            this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 553);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void removeParamFromStep(Object[] items) {
        try {
            VWFieldDefinition fieldDef = this.getSelectedFieldDefinition();
            this.m_stepVector = new Vector();
            for (int i = 0; i < items.length; ++i) {
                VWStepItem item = (VWStepItem)items[i];
                VWMapNode mapNode = item.getDef();
                if (mapNode == null || !(mapNode instanceof VWStepDefinition)) continue;
                ((VWStepDefinition)mapNode).deleteParameter(fieldDef.getName());
                item.setSelected(false);
                this.m_stepVector.addElement(item);
            }
            this.m_authPropertyData.setDirty();
            this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 553);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public boolean hasMaps() {
        if (this.m_submapComboBox != null) {
            return this.m_submapComboBox.getModel().getSize() > 0;
        }
        return false;
    }

    public void releaseReferences() {
        if (this.m_addRemovePanel != null) {
            this.m_addRemovePanel.removeReferences();
            this.m_addRemovePanel = null;
        }
        if (this.m_fieldBorder != null) {
            this.m_fieldBorder.removeReferences();
            this.m_fieldBorder = null;
        }
        if (this.m_fieldComboBox != null) {
            this.m_fieldComboBox.removeActionListener(this);
            this.m_fieldComboBox.removeAllItems();
            this.m_fieldComboBox = null;
        }
        if (this.m_modeBorder != null) {
            this.m_modeBorder.removeReferences();
            this.m_modeBorder = null;
        }
        if (this.m_modeComboBox != null) {
            this.m_modeComboBox.removeActionListener(this);
            this.m_modeComboBox.removeAllItems();
            this.m_modeComboBox = null;
        }
        if (this.m_stepsBorder != null) {
            this.m_stepsBorder.removeReferences();
            this.m_stepsBorder = null;
        }
        if (this.m_submapBorder != null) {
            this.m_submapBorder.removeReferences();
            this.m_submapBorder = null;
        }
        if (this.m_submapComboBox != null) {
            this.m_submapComboBox.removeActionListener(this);
            this.m_submapComboBox.removeAllItems();
            this.m_submapComboBox = null;
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            Object source = event.getSource();
            if (source == this.m_modeComboBox) {
                this.onMode();
            } else if (source == this.m_closeButton) {
                this.onClose();
            } else if (source == this.m_helpButton) {
                this.onHelp();
            } else if (source == this.m_submapComboBox) {
                this.performSubmapAction();
            } else if (source == this.m_fieldComboBox) {
                this.performFieldAction();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void notifyPropertyChange() {
    }

    public Vector getItemsChanged() {
        return this.m_stepVector;
    }

    private void reinitialize() {
        VWStepItem stepItem;
        int i;
        this.m_availableStepDefs = this.getAvailableStepDefs();
        this.m_selectedStepDefs = this.getSelectedStepDefs();
        VWFieldDefinition fieldDef = this.getSelectedFieldDefinition();
        if (fieldDef != null) {
            this.m_addRemovePanel.setListCellRenderer(new VWStepsListCellRenderer(fieldDef.getName()));
        } else {
            this.m_addRemovePanel.setListCellRenderer(new VWStepsListCellRenderer(null));
        }
        Object[] availableSteps = null;
        Object[] selectedSteps = null;
        if (this.m_selectedStepDefs != null) {
            Vector<VWStepItem> selectedStepsVector = new Vector<VWStepItem>();
            for (i = 0; i < this.m_selectedStepDefs.length; ++i) {
                stepItem = new VWStepItem(this.m_selectedStepDefs[i].getName(), this.m_selectedStepDefs[i]);
                stepItem.setSelected(true);
                selectedStepsVector.addElement(stepItem);
            }
            if (selectedStepsVector.size() > 0) {
                selectedSteps = new VWStepItem[selectedStepsVector.size()];
                selectedStepsVector.copyInto(selectedSteps);
            }
        }
        if (this.m_availableStepDefs != null) {
            Vector<VWStepItem> availableStepsVector = new Vector<VWStepItem>();
            for (i = 0; i < this.m_availableStepDefs.length; ++i) {
                stepItem = new VWStepItem(this.m_availableStepDefs[i].getName(), this.m_availableStepDefs[i]);
                stepItem.setSelected(false);
                availableStepsVector.addElement(stepItem);
            }
            if (availableStepsVector.size() > 0) {
                availableSteps = new VWStepItem[availableStepsVector.size()];
                availableStepsVector.copyInto(availableSteps);
            }
        }
        this.m_addRemovePanel.initializeLists(availableSteps, selectedSteps);
        this.m_addRemovePanel.refreshUI();
        this.m_modeComboBox.setEnabled(false);
    }

    private void createControls() {
        try {
            this.getContentPane().setLayout(new GridBagLayout());
            this.m_gbCons = new GridBagConstraints();
            this.m_gbCons.anchor = 23;
            this.m_gbCons.fill = 2;
            this.m_gbCons.gridx = 0;
            this.m_gbCons.gridy = 0;
            this.m_gbCons.gridwidth = 1;
            this.m_gbCons.gridheight = 1;
            this.m_gbCons.weightx = 1.0;
            this.m_gbCons.weighty = 0.0;
            this.m_gbCons.insets = new Insets(3, 3, 0, 3);
            this.m_fieldBorder = new VWToolbarBorder(VWResource.s_fieldNameStr);
            this.getContentPane().add((Component)this.m_fieldBorder, this.m_gbCons);
            JPanel clientPanel = this.m_fieldBorder.getClientPanel();
            clientPanel.setLayout(new GridLayout());
            this.m_fieldComboBox = new JComboBox();
            this.m_fieldComboBox.setName("m_fieldComboBox_VWFieldUsageDialog");
            this.m_fieldComboBox.setRenderer(new VWLabelListCellRenderer());
            this.m_fieldComboBox.addActionListener(this);
            clientPanel.add(this.m_fieldComboBox);
            ++this.m_gbCons.gridy;
            this.m_submapBorder = new VWToolbarBorder(VWResource.s_submap);
            this.getContentPane().add((Component)this.m_submapBorder, this.m_gbCons);
            JPanel submapPanel = this.m_submapBorder.getClientPanel();
            submapPanel.setLayout(new GridLayout());
            this.m_submapComboBox = new JComboBox();
            this.m_submapComboBox.setName("m_submapComboBox_VWFieldUsageDialog");
            this.m_submapComboBox.setRenderer(new VWLabelListCellRenderer());
            submapPanel.add(this.m_submapComboBox);
            ++this.m_gbCons.gridy;
            this.m_gbCons.weighty = 1.0;
            this.m_gbCons.fill = 1;
            this.m_gbCons.insets = new Insets(0, 3, 0, 3);
            this.m_stepsBorder = new VWToolbarBorder(VWResource.s_stepsStr);
            this.getContentPane().add((Component)this.m_stepsBorder, this.m_gbCons);
            JPanel stepsPanel = this.m_stepsBorder.getClientPanel();
            stepsPanel.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 23;
            gbCons.fill = 1;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.weightx = 1.0;
            gbCons.weighty = 1.0;
            this.m_addRemovePanel = new VWSelectStepPanel(this, 15);
            this.m_addRemovePanel.enableSorting(768);
            stepsPanel.add((Component)this.m_addRemovePanel, gbCons);
            this.m_gbCons.fill = 2;
            ++this.m_gbCons.gridy;
            this.m_gbCons.weighty = 0.0;
            this.m_modeBorder = new VWToolbarBorder(VWResource.s_accessRightStr, 0);
            JPanel accessRightPanel = this.m_modeBorder.getClientPanel();
            accessRightPanel.setLayout(new GridBagLayout());
            gbCons.anchor = 23;
            gbCons.fill = 2;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.weightx = 1.0;
            gbCons.weighty = 1.0;
            this.m_modeComboBox = new JComboBox();
            this.m_modeComboBox.setName("m_modeComboBox_VWFieldUsageDialog");
            this.m_modeComboBox.addItem(VWModeType.getLocalizedString(1));
            this.m_modeComboBox.addItem(VWModeType.getLocalizedString(2));
            this.m_modeComboBox.addItem(VWModeType.getLocalizedString(3));
            this.m_modeComboBox.setSelectedIndex(0);
            this.m_modeComboBox.setRenderer(new VWLabelListCellRenderer());
            this.m_modeComboBox.addActionListener(this);
            accessRightPanel.add((Component)this.m_modeComboBox, gbCons);
            this.getContentPane().add((Component)this.m_modeBorder, this.m_gbCons);
            JPanel bottomPanel = new JPanel(new GridBagLayout());
            gbCons.anchor = 10;
            gbCons.fill = 0;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.weightx = 1.0;
            gbCons.weighty = 1.0;
            gbCons.insets = new Insets(3, 3, 3, 3);
            this.m_closeButton = new JButton(VWResource.s_closeStr);
            this.m_closeButton.setName("m_closeButton_VWFieldUsageDialog");
            this.m_closeButton.addActionListener(this);
            bottomPanel.add((Component)this.m_closeButton, gbCons);
            ++gbCons.gridx;
            this.m_helpButton = new JButton(VWResource.s_help);
            this.m_helpButton.setName("m_helpButton_VWFieldUsageDialog");
            this.m_helpButton.addActionListener(this);
            bottomPanel.add((Component)this.m_helpButton, gbCons);
            this.m_gbCons.anchor = 10;
            this.m_gbCons.fill = 0;
            this.m_gbCons.gridx = 0;
            ++this.m_gbCons.gridy;
            this.m_gbCons.gridwidth = 1;
            this.m_gbCons.gridheight = 1;
            this.m_gbCons.weightx = 0.0;
            this.m_gbCons.weighty = 0.0;
            this.m_gbCons.insets = new Insets(6, 3, 6, 3);
            this.getContentPane().add((Component)bottomPanel, this.m_gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onMode() {
        try {
            VWFieldDefinition fieldDef = this.getSelectedFieldDefinition();
            Object[] items = this.m_addRemovePanel.getSelectedStepItems();
            int index = this.m_modeComboBox.getSelectedIndex();
            this.m_stepVector = new Vector();
            for (int i = 0; i < items.length; ++i) {
                VWParameterDefinition paramDef;
                VWStepItem item = (VWStepItem)items[i];
                VWMapNode mapNode = item.getDef();
                if (mapNode != null && mapNode instanceof VWStepDefinition && (paramDef = ((VWStepDefinition)mapNode).getParameterDefinition(fieldDef.getName())) != null) {
                    switch (index) {
                        case 0: {
                            paramDef.setMode(1);
                            break;
                        }
                        case 1: {
                            paramDef.setMode(2);
                            break;
                        }
                        case 2: {
                            paramDef.setMode(3);
                        }
                    }
                }
                this.m_stepVector.addElement(item);
            }
            this.m_addRemovePanel.refreshUI();
            this.m_authPropertyData.setDirty();
            this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 553);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onClose() {
        this.setVisible(false);
    }

    private void onHelp() {
        VWHelp.displayPage(VWHelp.Help_Process_Designer + "bpfdh148.htm");
    }

    private VWParameterDefinition getParamDef(VWStepDefinition stepDef) {
        VWParameterDefinition paramDef = null;
        try {
            if (stepDef != null) {
                VWFieldDefinition fieldDef = this.getSelectedFieldDefinition();
                paramDef = stepDef.getParameterDefinition(fieldDef.getName());
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return paramDef;
    }

    private void initMapComboBox() {
        this.m_submapComboBox.removeActionListener(this);
        try {
            if (this.m_authPropertyData != null) {
                this.m_submapComboBox.removeAllItems();
                VWMapCache vwMapCache = this.m_authPropertyData.getMapCache();
                if (vwMapCache != null) {
                    int i;
                    Object[] mapNames = null;
                    Vector<String> mapNamesVec = new Vector<String>();
                    VWMapDefinition[] mapDefs = vwMapCache.getCurrentMapDefinitions();
                    if (mapDefs != null) {
                        if (this.m_authPropertyData.getMapCache().get("Workflow", false) != null) {
                            this.m_submapComboBox.addItem("Workflow");
                        }
                        for (i = 0; i < mapDefs.length; ++i) {
                            String mapName = mapDefs[i].getName();
                            if (!vwMapCache.isEditable(mapName) || VWStringUtils.compare(mapName, "Workflow") == 0) continue;
                            mapNamesVec.addElement(mapName);
                        }
                        mapNames = new String[mapNamesVec.size()];
                        mapNamesVec.copyInto(mapNames);
                    }
                    if (mapNames != null && mapNames.length > 0) {
                        VWQubbleSort.sort(mapNames);
                        for (i = 0; i < mapNames.length; ++i) {
                            this.m_submapComboBox.addItem(mapNames[i]);
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        this.m_submapComboBox.addActionListener(this);
    }

    private VWStepDefinition[] getAvailableStepDefs() {
        Object[] stepDefs = null;
        Vector<VWStepDefinition> stepDefVector = new Vector<VWStepDefinition>();
        try {
            if (this.m_authPropertyData != null && this.m_submapComboBox.getSelectedItem() != null) {
                VWMapNode[] mapNodes;
                int mapNodeCount;
                VWMapDefinition mapDef;
                String mapName = this.m_submapComboBox.getSelectedItem().toString();
                VWWorkflowDefinition wfDef = this.m_authPropertyData.getWorkflowDefinition();
                if (wfDef != null && (mapDef = wfDef.getMap(mapName)) != null && (mapNodeCount = (mapNodes = mapDef.getSteps()).length) > 0) {
                    for (int i = 0; i < mapNodeCount; ++i) {
                        VWStepDefinition stepDef;
                        String operationName;
                        if (!(mapNodes[i] instanceof VWStepDefinition) || (operationName = (stepDef = (VWStepDefinition)mapNodes[i]).getOperationName()) != null && operationName.length() != 0) continue;
                        stepDefVector.addElement(stepDef);
                    }
                    stepDefs = new VWStepDefinition[stepDefVector.size()];
                    stepDefVector.copyInto(stepDefs);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return stepDefs;
    }

    private VWStepDefinition[] getSelectedStepDefs() {
        Object[] stepDefs = null;
        Vector<VWStepDefinition> stepDefVector = new Vector<VWStepDefinition>();
        try {
            int availableStepDefCount;
            VWFieldDefinition fieldDef = this.getSelectedFieldDefinition();
            if (this.m_availableStepDefs != null && (availableStepDefCount = this.m_availableStepDefs.length) > 0) {
                block2: for (int i = 0; i < availableStepDefCount; ++i) {
                    int paramDefCount;
                    VWStepDefinition stepDef = this.m_availableStepDefs[i];
                    VWParameterDefinition[] paramDefs = stepDef.getParameterDefinitions();
                    if (paramDefs == null || (paramDefCount = paramDefs.length) <= 0) continue;
                    for (int j = 0; j < paramDefCount; ++j) {
                        VWParameterDefinition paramDef = paramDefs[j];
                        String paramName = paramDef.getName();
                        if (VWStringUtils.compare(paramName, fieldDef.getName()) != 0) continue;
                        stepDefVector.addElement(stepDef);
                        continue block2;
                    }
                }
                stepDefs = new VWStepDefinition[stepDefVector.size()];
                stepDefVector.copyInto(stepDefs);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return stepDefs;
    }

    private void performSubmapAction() {
        this.reinitialize();
    }

    private void performFieldAction() {
        this.reinitialize();
    }

    private void initFieldComboBox() {
        this.m_fieldComboBox.removeActionListener(this);
        try {
            if (this.m_authPropertyData != null) {
                this.m_fieldComboBox.removeAllItems();
                Object[] fieldDefs = this.m_authPropertyData.getFields();
                int fieldDefCount = fieldDefs.length;
                if (fieldDefCount > 0) {
                    VWQubbleSort.sort(fieldDefs);
                    for (int i = 0; i < fieldDefCount; ++i) {
                        String fieldName = ((VWFieldDefinition)fieldDefs[i]).getName();
                        if (VWStringUtils.compare(fieldName, "F_Trackers") == 0) continue;
                        this.m_fieldComboBox.addItem(fieldDefs[i]);
                    }
                    this.m_fieldComboBox.setSelectedItem(this.m_fieldDef);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        this.m_fieldComboBox.addActionListener(this);
    }

    private VWFieldDefinition getSelectedFieldDefinition() {
        VWFieldDefinition fieldDef = (VWFieldDefinition)this.m_fieldComboBox.getSelectedItem();
        return fieldDef;
    }
}

